// ---------------------------------------------------
// File: RegexUtil.java
//
// Copyright 1998 Veo Systems
// Copyright 1999,2000,2001 Commerce One, Inc
// All Rights Reserved.
//
// $RCSfile: RegexUtil.java,v $
// $Revision: 1.4 $
// $Date: 1999/01/23 02:58:28 $
// $Author: kenneth $
// ---------------------------------------------------


package com.amichel.util.regex;

import com.amichel.util.regex.RegExp;
import com.amichel.util.regex.MatchInfo;
import com.amichel.util.debug.Contract;

/**
* RegexUtil is helper functions for Regex's
*/
public final class RegexUtil
{
  /**
   * Default constructor
   */
  private RegexUtil()
  {
  }

  /**
   * Checks that a candidate string matches a regular expression
   * 
   * @param regex     The regular expression
   * @param candidate The candidate string
   * @return true if regex matches entire candidate, false otherwise
   */
  public static boolean compareString(String regex, String candidate)
  {
    if( candidate == null ) // Can't match null string
      return false;

    RegExp reg = null;

    try
    {
      reg = new RegExp( regex );
    }
    catch( Exception ex )
    {
      return false;
    }

    MatchInfo match = reg.match( candidate );

    if( match != null )
      // Match if complete string
      return(match.start() == 0 && match.end() ==candidate.length());
    else
      return false;
  }
  
  public static MatchInfo findString( String regex, String candidate )
  {
	  if( Contract.	REQUIRE )
	  {
		  Contract.require( regex != null, "Regular expression must be non-null" );
		  Contract.require( candidate != null, "Candiate expression in regex search must be non-null" );
	  }
	  
	  RegExp regexp = null;
	  
	  try
	  {
		  regexp = new RegExp( regex );
	  }
	  catch( Exception ex )
	  {
		  if( Contract.REQUIRE )
			  Contract.require( false, "RegExp constructor thrown exception - something wrong with the regexp string" );
	  }
	  
	  return regexp.match( candidate );
  }
	  
	  
}
