// ---------------------------------------------------
// File: Logger.java
//
// Copyright (C) 1998 Veo Systems
// Written by Henrik Martin
// All rights reserved.
//
// $Id: Logger.java,v 1.10 1999/03/10 06:53:00 kenneth Exp $
// ---------------------------------------------------

package com.amichel.util.debug;

/**
 * Interface that defines a bunch of methods/constants
 * for message logging.
 *
 * @version $Revision: 1.10 $
 */
public interface Logger
{
  // Some constants for log levels
  int DEBUG = 0;
  int INFO = 1;
  int WARNING = 2;
  int ERROR = 3;
  int CRITICAL = 4;
  int FATAL = 5;
  int LOWEST = DEBUG;
  int HIGHEST = FATAL;    
  String DEFAULT_LABEL = "Debug";

  // String representation of the various log levels
  String[] dbgNames = { "DEBUG", "INFO", "WARNING",
		       "ERROR", "CRITICAL", "FATAL" };
  public void info(String msg);
  public void debug(String msg);
  public void warn(String msg);
  public void error(String msg);
  public void crit(String msg);
  public void fatal(String msg);
  public void setLogParams(String newPrefix, boolean useFileAndNum);
}
