package com.amichel;

import java.net.*;
import java.io.*;
import com.amichel.util.debug.Contract;
import java.util.Vector;

class Worker extends WebServer implements Runnable
{
	private final static int BUF_SIZE = 2048;

	private static final byte[] EOL = {(byte)'\r', (byte)'\n'};
	
	private IJAlerts _statusCallback;

	/* Socket to client we're handling */
	private Socket s;
	
	Worker() 
	{
		_statusCallback = new IJAlerts();
		s = null;
	}

	synchronized void setSocket(Socket s) 
	{
		this.s = s;
		notify();
	}

	public synchronized void run() 
	{
		while (true)
		{
			if (s == null)
			{
				/* nothing to do */
				try
				{
					wait();
				}
				catch (InterruptedException e)
				{
					/* should not happen */
					continue;
				}
			}
			try
			{
				if( !handleClient() )
					break;
			}
			catch (IOException e)
			{
				System.out.println( e.getMessage() );
				e.printStackTrace();
			}
			/* go back in wait queue if there's fewer
			* than numHandler connections.
			*/
			s = null;
			Vector pool = WebServer.threads;
			synchronized (pool)
			{
				if (pool.size() >= WebServer.workers)
				{
					/* too many threads, exit this one */
					return;
				}
				else
				{
					pool.addElement(this);
				}
			}
		}
	}

	private static final String REQ = "req?";
	
	String processRequest() throws IOException
	{
		InputStreamReader is = new InputStreamReader( s.getInputStream() );
		//TODO: get rid of the 1000, make something more flexible
		char req[] = new char[1000];
		int n = is.read( req );
		
		String request = new String( req );
		
//		System.out.println( request );
		
		int start = request.indexOf( REQ );
		if( start >= 0 )
			start += REQ.length();
		else
		{
			//TODO: handle error - not a valid command line
			return null;
		}
		
		int end = request.indexOf( ')' );
		if( end >= 0 )
			end++;
		else
		{
			//TODO: handle error - not a valid command line
			return null;
		}
		
		//TODO: check the IP address, reject request if it's not 127.0.0.1
		
		String cmd = request.substring( start, end );
		
		Command command = new Command( request.substring( start, end ) );

		return processCommand( command );
	}
	
	String processCommand( Command command )
	{
		String str = null;
		System.out.println( command );
		
		switch( command.getCommand() )
		{
		case Command.GET_LAST_QUOTE:
			str = "OK\r\n";
			str += _quoteSource.getInfo( command.getArgs() );
			break;
		case Command.ADD_STOCKS_TO_PORT:
			_quoteSource.addSymbols( command.getArgs() );
			str = OK_PORTFOLIO_UPDATED;
			break;
		case Command.REMOVE_STOCKS_FROM_PORT:
			_quoteSource.removeSymbols( command.getArgs() );
			str = OK_PORTFOLIO_UPDATED;
			break;
		default:
			if( Contract.REQUIRE )
				Contract.require( false, "Unknown command - cannot process" );
			break;
		}											
		return str;
	}
		

	String getStringLengthAsString( String str )
	{
		Integer i = new Integer( str.length() );
		return i.toString();
	}
		

	boolean handleClient() throws IOException 
	{
		String str = processRequest();
		
		if( str == null )
			return false;
		
		PrintWriter ps = new PrintWriter(s.getOutputStream());
				
		ps.println( "HTTP/1.0 200 OK" );
		ps.flush();
		ps.println( "Server: QuoteTracker" );
		ps.flush();
		ps.println( "Content-Type: text/plain" );
		ps.flush();
		ps.println( "Content-Length: " );
		ps.println( getStringLengthAsString( str ) );
		ps.flush();
		ps.println( "" );
		ps.flush();
		ps.print( str );
		ps.flush();
		s.close();
		return true;
	}
}