package com.amichel;




/* An example of a very simple, multi-threaded HTTP server.
 * Implementation notes are in WebServer.html, and also
 * as comments in the source code.
 */
import java.io.*;
import java.net.*;
import java.util.*;
import com.amichel.util.regex.*;
import com.amichel.util.debug.Contract;
import wlalerts.*;
						  
public class WebServer
{
	/* print to stdout */
	protected static void p(String s) { System.out.println(s); }
	protected static void log(String s)
	{ 
		synchronized (log)  
		{
			log.println(s);
			log.flush();
		}
	}

	static final int _port = 16239;

	static PrintWriter log = null;
	/* our server's configuration information is stored
	* in these properties
	*/
	/* Where worker threads stand idle */
	static Vector threads = null;

	/* timeout on client connections */
	static int timeout;

	/* max # worker threads */
	static int workers;
	static LoginInfos _loginInfos = null;
	
	private static boolean _comMode;
	private static String _comInitArg;
	
	protected static QuoteSource _quoteSource = null;
	
	protected static final String OK_PORTFOLIO_UPDATED = "OK portfolio updated";

	private static final String COM_MODE_FLAG = "com";
	
	static
	{
		_loginInfos = new LoginInfos();
		threads = new Vector();
		timeout = 5000;
		workers = 1;
	}
	
	private static void cmdLineError()
	{
		System.out.println( "Command line error\n" );
		usage();
	}
	
	private static void usage()
	{
		System.out.println( "Usage:" );
		System.out.println( "\tjalerts /? - to display this message" );
		System.out.println( "\tjalerts /streamer user password - to use Streamer as real time quote source" );
		System.out.println( "\tjalerts /com \"com init string\" - to use another library as a real time quote source" );
		System.out.println( "Please refer to the readme.doc file for more details" );
	}
	
	private static void welcomeMessage()
	{
		System.out.println();
		System.out.println( "***********************************************" );
		System.out.println( "*     WealthLab (C) Alert Manager Adapter     *" );
		System.out.println( "* (C) 2002 Adrian Michel - michel@pacbell.net *" );
		System.out.println( "***********************************************" );
		System.out.println();
	}
	
	private static boolean cmdLine( String[] a )
	{
		if( a.length < 1 )
		{
			cmdLineError();
			return false;
		}
		
		if( a.length == 2 )
		{
			if( a[ 0 ].equals( "/com" ) )
			{
				_comMode = true;
				_comInitArg = a[ 1 ];
				return true;
			}
			else
			{
				cmdLineError();
				return false;
			}
		}
		else if( a.length == 1 )
		{
			if( a[ 0 ].equals( "/?" ) )
				usage();
			else if( a[ 0 ].equals( "/com" ) )
			{
				_comMode = true;
				_comInitArg = null;
				return true;
			}
			else
				cmdLineError();
			return false;
		}
		else if( a.length >= 3 )
		{
			if( a[ 0 ].equals( "/streamer" ) )
			{
				_comMode = false;
				for( int n = 1; n < a.length; n += 2 )
					_loginInfos.addLogin( a[ n ], a[ n + 1] );
								
				return true;
			}
			else
			{
				cmdLineError();
				return false;
			}
		}
		return false;
	}

	public static void main(String[] a) throws Exception 
	{
		welcomeMessage();
		if( !cmdLine( a ) )
			return;
		
		System.out.println( _comMode ? "* Running in COM mode *" : "* Running in Streamer mode* " );
		System.out.println();
		
		/* start worker threads */
		if( _comMode )
			_quoteSource = new COMQuoteSource( _comInitArg );
		else
			_quoteSource = new StreamerQuoteSource( _loginInfos );

		for (int i = 0; i < workers; ++i)
		{
			Worker w = new Worker();
			(new Thread(w, "worker #"+i)).start();
			threads.addElement(w);
		}

		System.out.println( "Waiting for WealthLab commands" );
		ServerSocket ss = new ServerSocket( _port );
		while (true)
		{

			Socket s = ss.accept();

			Worker w = null;
			synchronized (threads) 
			{
				if (threads.isEmpty())
				{
					Worker ws = new Worker();
					ws.setSocket(s);
					(new Thread(ws, "additional worker")).start();
				}
				else
				{
					w = (Worker) threads.elementAt(0);
					threads.removeElementAt(0);
					w.setSocket(s);
				}
			}
		}
	}

	public void processOption( String opt, String value )
	{
	}
	
	public void processApplication( String[] remainingArgs )
	{
	}
}


