package com.amichel;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Date;

public class Symbols
{
	private class SymbolInfo
	{
		private Double _last;
		private Double _bid;
		private Double _ask;
		private Double _prevClose;
		private Date _date;
		private boolean _set;
		
		SymbolInfo()
		{
			_set = false;
			_last = null;
			_date = null;
			_prevClose = null;
			_bid = null;
			_ask = null;
		}
		
		private boolean set()
		{
			boolean set = _set;
			_set = true;
			return set;
		}

		boolean setLast( double last ) { _last = new Double( last ); return set(); }
		boolean setPrevClose( double prevClose ) { _prevClose = new Double( prevClose ); return set(); }
		boolean setBid( double bid ) { _bid = new Double( bid ); return set(); }
		boolean setAsk( double ask ) { _ask = new Double( ask ); return set(); }
		
		
		Double getLast() { return _last; }
		Double getBid() { return _bid; }
		Double getAsk() { return _ask; }
		Double getPrevClose() { return _prevClose; }
		
		Double getChange() 
		{ 
			if( _prevClose == null || _last == null )
				return null;
			else
				return new Double( _last.doubleValue() - _prevClose.doubleValue() ); 
		}
		
		String getLastAsString()
		{
			if( _last == null )
				return "-1";
			else
				return _last.toString();
		}

		String getPrevCloseAsString()
		{
			if( _prevClose == null )
				return "-1";
			else
				return _prevClose.toString();
		}

		String getAskAsString()
		{
			if( _ask == null )
				return "-1";
			else
				return _ask.toString();
		}

		String getBidAsString()
		{
			if( _bid == null )
				return "-1";
			else
				return _bid.toString();
		}

		String getChangeAsString()
		{
			Double change = getChange();
			if( change != null )
				return change.toString();
			else
				return "-1";
		}
		
		boolean isSet() { return _set; }
		void reset() { _set = false; }
	}
	
	private Dictionary _symbols;
	private Enumeration _e;
	
	public Symbols()
	{
		_symbols = new Hashtable();
		_e = _symbols.elements();
	}
	
	public synchronized void addSymbol( String symbol )
	{
		_symbols.put( symbol, new SymbolInfo() );
		_e = _symbols.elements();
	}

	// returns false if there is no new symbol, and true if there is at least one new symbol
	public synchronized boolean addSymbols( Enumeration symbols )
	{
		boolean b = false;
		while( symbols.hasMoreElements() )
		{
			String symbol = (String)symbols.nextElement();
			
			if( _symbols.get( symbol ) == null )
			{
				b = true;
				addSymbol( symbol );
			}
		}
		if( b )
			_e = _symbols.elements();
		return b;
	}
	
	public synchronized boolean setLast( String symbol, double last )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
		{
			si.setLast( last );
			return true;
		}
		else
			return false;
	}
	
	public synchronized boolean setAsk( String symbol, double ask )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
		{
			si.setAsk( ask );
			return true;
		}
		else
			return false;
	}

	
	public synchronized boolean setBid( String symbol, double bid )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
		{
			si.setBid( bid );
			return true;
		}
		else
			return false;
	}

	public synchronized boolean setPrevClose( String symbol, double prevClose )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
		{
			si.setPrevClose( prevClose );
			return true;
		}
		else
			return false;
	}

	public synchronized void removeSymbol( String symbol )
	{
		_symbols.remove( symbol );
		_e = _symbols.elements();
	}
	
	public synchronized Double getLast( String symbol )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
			return si.getLast();
		else
			return null;
	}
	
	public synchronized Double getChange( String symbol )
	{
		SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
		if( si != null )
			return si.getChange();
		else
			return null;
	}
	
	public synchronized String getLastPricesAsString( Enumeration symbols )
	{
		String s = new String();

		while( symbols.hasMoreElements() )
		{
			String symbol = (String)symbols.nextElement();
			SymbolInfo si = (SymbolInfo)_symbols.get( symbol );
			if( si != null )
			{
			
				s += symbol + "," + "-1,-1," + si.getLastAsString() + "," + si.getBidAsString() + "," + si.getAskAsString() + "," + si.getChangeAsString() + ",-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1\r\n";
			}
		}
		return s;
	}
	
	public synchronized Vector toStrings( int size )
	{
		boolean b = true;
		int count = 0;
		Vector vector = new Vector();
		String str = null;
		
		for( Enumeration e = _symbols.keys(); e.hasMoreElements(); )
		{
			String symbol = (String)e.nextElement();
			
			if( count == 0 )
			{
				str = new String();
				str += symbol;
			}
			else
			{
				str += "+" + symbol;
			}
			if( ++count == size )
			{
				count = 0;
				vector.addElement( str );
			}
		}
		if( count != 0 )
			vector.addElement( str );
		
		return vector;
	}
	
	public synchronized Dictionary getNextSymbols( int size )
	{
		Dictionary v = new Hashtable();
		
		while( _e.hasMoreElements()  )
		{
			String symbol = (String)_e.nextElement();
			v.put( symbol, symbol );
			
			if( --size == 0 )
				return v;
		}
		_e = _symbols.elements();
		return v;
	}
}
