package com.amichel;

import java.util.Vector;
import com.amichel.util.debug.Contract;
import java.math.BigDecimal;

public class StreamerQuoteSource implements QuoteSource
{
	private Symbols _symbols;
	private LoginInfos _loginInfos;
	private Vector _connections;
	private boolean _newSymbols;
	
	StreamerQuoteSource( LoginInfos loginInfos )
	{
		_connections = new Vector();
		_newSymbols = false;
		_symbols = new Symbols();
		_loginInfos = loginInfos;
        for( int n = 0; n < loginInfos.size(); n++ )
	       _connections.addElement( new StreamerConnectionThread( loginInfos.getLoginInfo( n ), _symbols ) );
	}
	
	public String getInfo( Command.Args args )
	{
		connect();
		return _symbols.getLastPricesAsString( args.getArgs() );
	}
	
	private void connect()
	{
		if( _newSymbols )
		{
			Vector syms = _symbols.toStrings( 75 );
			
			for( int n = 0; n < syms.size() && n < _connections.size(); n++ )
			{
				String sym = (String)syms.elementAt( n );
				StreamerConnectionThread conn = (StreamerConnectionThread)_connections.elementAt( n );
				conn.reconnect( sym );
			}
				
			_newSymbols = false;
		}
	}
	
	public void addSymbols( Command.Args args )
	{
		if( Contract.REQUIRE )
			Contract.require( args != null, "StreamerQuoteSource - args cannot be null" );
		
		_symbols.addSymbols( args.getArgs() );
		_newSymbols = true;
	}
	
	public void removeSymbols( Command.Args args )
	{
	}
}

