package com.amichel;

import java.io.*;
import java.net.*;
import java.util.Enumeration;
import com.amichel.exceptions.SymbolNotFoundException;
import com.amichel.util.debug.Contract;

public class StreamerConnectionThread extends Thread implements FieldConstants
{
	private boolean _cont = false;
	private boolean _connected = false;
	private int _reconnects = 3;
	Symbols _symbols;
	String _query = null;
	StringBuffer _buf;
	char _last;
	boolean _isFirst;
	LoginInfo _loginInfo;
	static final String _server = "http://investment.datek.com/";
	static final String _fields;
	
	static
	{
		_fields = (new Integer( BID ) ).toString() + "+" +
				 (new Integer( ASK ) ).toString() + "+" +
				 (new Integer( LAST ) ).toString() + "+" +
				 (new Integer( PREV_CLOSE ) ).toString();
	}

	protected StreamerConnectionThread( LoginInfo loginInfo, Symbols symbols )
	{
		_loginInfo = loginInfo;
		_buf = new StringBuffer();
		_symbols = symbols;
		start();
	}

	private void processChar( char c )
		throws SymbolNotFoundException
	{
//		System.out.print( c );
		if( _isFirst )
		{
			_last = c;
			_isFirst = false;
		}
		else if( _last == 0x00ff && c == 0x000a )
		{
			processQuote( _buf.toString() );
			_buf.setLength( 0 );
			_isFirst = true;
		}
		else
		{
			_buf.append( _last );
			_last = c;
		}
	}

/**	public void addSymbols( Command.Args args )
	{
		if( Contract.REQUIRE )
			Contract.require( args != null, "WLStreamerConnectionThread.WLStreamerConnectionThread - SymbolsToPeriods cannot be null" );

		if( _symbols.addSymbols( args.getArgs() ) )
		{
			// new symbols, so reconnect
			reconnect();
		}
	}
*/	
	public void reconnect( String symbols )
	{
		System.out.println( "Reconnect: " + symbols );
		_query = makeQuery( symbols );
		_cont = false;
		while( _connected )
		{
			try
			{
				sleep( 100 );
			}
			catch( InterruptedException e )
			{
			}
		}
		_cont = true;
	}
	
	private void writeInFile( String str )
	{
		FileWriter file = null;
		try
		{
			file = new FileWriter( "d:\\" + _loginInfo.getUserName() + ".txt", true );
			file.write( "  " + str + "  " );
			file.close();
		}
		catch( IOException e )
		{
		}
		finally
		{
			try
			{
				if( file != null )
					file.close();
			}
			catch( IOException e )
			{
			}
		}
	}		
		
	private void writeInFile( int c )
	{
		FileWriter file = null;
		try
		{
			file = new FileWriter( "d:\\" + _loginInfo.getUserName() + ".txt", true );
			file.write( c );
			file.close();
		}
		catch( IOException e )
		{
		}
		finally
		{
			try
			{
				if( file != null )
					file.close();
			}
			catch( IOException e )
			{
			}
		}
	}		
		

	private void processQuote( String quote )
		throws SymbolNotFoundException
	{
		QuoteParser parser = new QuoteParser();

		if( quote.indexOf( "PLX" ) >= 0 )
		{
			System.out.println( "plxs!!!!" );
		}

		QuoteParser.FieldMap fm = parser.parseQuote( quote );

		if( fm != null )
		{
			for( Enumeration e = fm.elements(); e.hasMoreElements(); )
			{
				QuoteParser.Field field = (QuoteParser.Field)e.nextElement();
				processField( fm.getSymbol(), field );
			}
		}
	}

	private void processField( String symbol, QuoteParser.Field field )
		throws SymbolNotFoundException
	{
		if( Contract.REQUIRE )
		{
			Contract.require( symbol != null, "WLStreamerConnectionThread.processField - symbol cannot be null" );
			Contract.require( field != null, "WLStreamerConnectionThread.processField - field cannot be null" );
		}
		
		System.out.println( _loginInfo.getUserName() + " : " + symbol );

		switch( field.getId() )
		{
			case LAST:
				{
					DoubleValue d = (DoubleValue)field.getValue();
					_symbols.setLast( symbol, d.getValue() );
				}
				break;
			case ASK:
				{
					DoubleValue d = (DoubleValue)field.getValue();
					_symbols.setAsk( symbol, d.getValue() );
				}
				break;
			case BID:
				{
					DoubleValue d = (DoubleValue)field.getValue();
					_symbols.setBid( symbol, d.getValue() );
				}
				break;
			case PREV_CLOSE:
				{
					DoubleValue d = (DoubleValue)field.getValue();
					_symbols.setPrevClose( symbol, d.getValue() );
				}
				break;
			default:
				// ignore other fields
				break;
		}
	}

	private String makeQuery( String symbols )
	{

		return "!U=" + _loginInfo.getUserName() + "&w=" + _loginInfo.getPassword() + "|S=QUOTE&C=SUBS&P=" + symbols + "&T=0+" + _fields;
	}


	public void run()
	{
//		System.out.println( "Running connection thread" );
		Writer file = null;
		while( true )
		{
			try
			{
				while( !_cont )
				{
					_reconnects = 3;
					sleep( 100 );
				}
			}
			catch( InterruptedException e )
			{
			}

			_connected = true;
			URL url;
			String line;
			int responseCode;
			HttpURLConnection connection = null;
			InputStream input;
			BufferedReader dataInput;

			try
			{
				String urlString = _server + _query;
//				System.out.println( "streamer connection url: " + urlString );
				url = new URL( _server + _query );
//				url = new URL( "http://investment.datek.com/!U=michel2289&w=2A6BC43F9797CDD69765BB09882216941E98814A|S=QUOTE&C=SUBS&P=GILD+AAPL+MWD+MAR+AVP+L+MEDI+KRB+FITB+MOLX+CSCO+MU+ADI+AMZN+HDI+ERTS+AXP+LLTC+MSFT+BSC+HON+BBBY+BAC+IDPH&T=0+3+8" );
				if( _reconnects == 3 )
					System.out.println( "Connecting to Streamer: " + urlString );
				else
					System.out.println( "Reconnecting to Streamer: " + urlString );
				connection = (HttpURLConnection)url.openConnection();
				responseCode = connection.getResponseCode();

				if ( responseCode != HttpURLConnection.HTTP_OK )
				{
					System.out.println( "Cannot connect to Streamer, exiting..." );
					System.exit( 1 );
				}
				
//				System.out.println( "Connected to Streamer" );

				String s = connection.getResponseMessage();

				int c;
				input = connection.getInputStream();
				
				boolean f = true;
				int count = 0;
				while( ( (c = input.read() ) >= 0 ) && _cont )
				{
					writeInFile( c );
					count++;
					if( f && count > 200 )
					{
						System.out.println( "Receiving quotes" );
						f = false;
					}
					processChar( (char)c );
				}
				
				if( _cont )
				{
					
					System.out.println( "Disconnected, trying to reconnect..." );
					x();
				}
			}
			catch( IOException ex )
			{
					System.out.println( "Connection problem, trying to (re)connect..." );
					x();
			}
			catch( SymbolNotFoundException ex )
			{
					System.out.println( "Connection problem, trying to (re)connect..." );
					x();
			}
			finally
			{
				if( connection != null )
					connection.disconnect();
//				System.out.println( "Exiting connection thread" );
				_connected = false;

				try
				{
					if( file != null )
						file.close();
				}
				catch( IOException e )
				{
				}
			}
		}
	}
	
	public void removeSymbols( Command.Args symbols )
	{
	}

	private void x()
	{
		try
		{
			_reconnects--;
			sleep( 1000 );
			if( _reconnects == 0 )
			{
				System.out.println( "Cannot (re)connect to Streamer, exiting..." );
				System.exit( 1 );
			}
		}
		catch( InterruptedException e )
		{
		}
	}
		
}
