package com.amichel;

import java.util.StringTokenizer;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Enumeration;

public class Command
{
	public static final int GET_LAST_QUOTE = 0;
	public static final int ADD_STOCKS_TO_PORT = 1;
	public static final int REMOVE_STOCKS_FROM_PORT = 2;
	public static final int UNKNOWN = 3;
	
	private int _cmd;
	private Args _args;
	

	public int getCommand() { return _cmd; }
	public Command( String cmd )
	{
		setCmd( cmd );
		setArgs( cmd );
	}
	
	public Args getArgs()
	{
		return _args;
	}
	
	private void setArgs( String cmd )
	{
		_args = new Args( cmd );
	}
	
	private void setCmd( String cmd )
	{
		if( cmd.indexOf( "getLastQuote" ) >= 0 )
			_cmd = GET_LAST_QUOTE;
		else if( cmd.indexOf( "AddStocksToPort" ) >= 0 )
			_cmd = ADD_STOCKS_TO_PORT;
		else if( cmd.indexOf( "RemoveStocksFromPort" ) >= 0 )
			_cmd = REMOVE_STOCKS_FROM_PORT;
		else
			_cmd = UNKNOWN;
	}
	
	public String toString()
	{
		String str;
		switch( _cmd )
		{
		case GET_LAST_QUOTE:
			str = "Last Quote command";
			break;
		case ADD_STOCKS_TO_PORT:
			str = "Add Stocks to Portfolio";
			break;
		case REMOVE_STOCKS_FROM_PORT:
			str = "Remove Stocks to Portfolio";
			break;
		case UNKNOWN:
		default:
			str = "Unknown command";
			break;
		}
		return str;
	}
	
	public class Args
	{
		private Dictionary _args = null;
		private String _strArgs = null;
		private int _size;
		
		Args( String cmd )
		{
			_size = 0;
			_args = new Hashtable();
			
			int start = cmd.indexOf( "(" );
			if( start < 0 )
			{
				//TODO: error, malformed
			}
			else
				start++;
			
			int end = cmd.indexOf( ")" );
			if( end < 0 )
			{
				//TODO: error, malformed
			}
			
			
			String args = cmd.substring( start, end );
			
			if( args.indexOf( "CURRENT," ) >= 0 )
				args = args.substring( 8 );
			_strArgs = new String( args );
			StringTokenizer st = new StringTokenizer( args, "," );
			
			while( st.hasMoreTokens() )
			{
				String s = st.nextToken();
				_args.put( s, s );
				_size++;
				
//				System.out.println( s );
			}
		}
		
		Enumeration getArgs()
		{
			return _args.elements();
		}
		
		int size() { return _size; }
		
		String getArgsAsString()
		{
			return _strArgs;
		}
		
	}
}
