package com.amichel;

import wlalerts.IIWLAlerts;
import wlalerts.IWLAlerts;
import com.ms.com.ComError;

public class COMQuoteSource implements QuoteSource
{
	private IIWLAlerts _alerts = null;
	private IJAlerts _statusCallback = null;
									
	public COMQuoteSource( String init )
	{
		try
		{
			_alerts = new IWLAlerts();
			_statusCallback = new IJAlerts();
			_alerts.Init( init );
			_alerts.SetStatusCallback( _statusCallback );
		}
		catch( ComError e )
		{
			// TODO: handle exceptions here (rethrow maybe)
			System.out.println( "COM error: " + e.getMessage() );
			System.exit( 1 );
		}
	}
	
	public String getInfo( Command.Args args )
	{
		try
		{
			return _alerts.GetLastQuote( args.getArgsAsString() );
		}
		catch( ComError e )
		{
			// TODO: handle exceptions here (rethrow maybe)
			System.out.println( "COM error: " + e.getMessage() );
			System.exit( 1 );
			return null;
		}
	}
	
	public void addSymbols( Command.Args args )
	{
		try
		{
			_alerts.AddStocks( args.getArgsAsString() );
		}
		catch( ComError e )
		{
			System.out.println( "COM error: " + e.getMessage() );
			System.exit( 1 );
		}
	}
	
	public void removeSymbols( Command.Args args )
	{
		try
		{
			_alerts.RemoveStocks( args.getArgsAsString() );
		}
		catch( ComError e )
		{
			System.out.println( "COM error: " + e.getMessage() );
			System.exit( 1 );
		}
	}
}
